/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import java.util.Vector;
import org.apache.xalan.xpath.ExtensionFunctionHandler;
import org.apache.xalan.xpath.dtm.DTMLiaison;
import org.apache.xalan.xpath.xml.FormatterToDOM;
import org.apache.xalan.xpath.xml.FormatterToHTML;
import org.apache.xalan.xpath.xml.FormatterToText;
import org.apache.xalan.xpath.xml.FormatterToXML;
import org.apache.xalan.xpath.xml.MutableAttrListImpl;
import org.apache.xalan.xpath.xml.QName;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.apache.xalan.xslt.ElemApplyTemplates;
import org.apache.xalan.xslt.ElemTemplate;
import org.apache.xalan.xslt.ElemValueOf;
import org.apache.xalan.xslt.Stylesheet;
import org.apache.xalan.xslt.XSLProcessorException;
import org.apache.xalan.xslt.XSLTEngineImpl;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTProcessorFactory;
import org.apache.xalan.xslt.XSLTResultTarget;
import org.apache.xalan.xslt.trace.SelectionEvent;
import org.apache.xalan.xslt.trace.TraceListener;
import org.apache.xalan.xslt.trace.TracerEvent;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public class StylesheetRoot
extends Stylesheet
implements Serializable {
    String m_resultNameSpaceURL = null;
    transient Vector m_traceListeners = null;
    static final String DEFAULT_ENCODING = "UTF-8";
    String m_liaisonClassUsedToCreate = null;
    public boolean m_useXercesSerializers = false;
    String m_outputmethod = null;
    String m_version = null;
    boolean m_indentResult = false;
    String m_encoding = null;
    String m_mediatype = null;
    String m_doctypeSystem = null;
    String m_doctypePublic = null;
    boolean m_omitxmlDecl = false;
    boolean m_standalone = false;
    QName[] m_cdataSectionElems = null;
    transient Stack m_importStack;
    public ElemTemplate m_defaultTextRule;
    public ElemTemplate m_defaultRule;
    public ElemTemplate m_defaultRootRule;

    public StylesheetRoot(XSLTEngineImpl xSLTEngineImpl, String string) throws XSLProcessorException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        super(null, xSLTEngineImpl, string);
    }

    public void addTraceListener(TraceListener traceListener) throws TooManyListenersException {
        if (this.m_traceListeners == null) {
            this.m_traceListeners = new Vector();
        }
        this.m_traceListeners.addElement(traceListener);
    }

    void fireSelectedEvent(SelectionEvent selectionEvent) throws SAXException {
        if (this.m_traceListeners != null) {
            int n = this.m_traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.m_traceListeners.elementAt(n2);
                traceListener.selected(selectionEvent);
                ++n2;
            }
        }
    }

    void fireTraceEvent(TracerEvent tracerEvent) {
        if (this.m_traceListeners != null) {
            int n = this.m_traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.m_traceListeners.elementAt(n2);
                traceListener.trace(tracerEvent);
                ++n2;
            }
        }
    }

    public QName[] getCDataSectionElems() {
        return this.m_cdataSectionElems;
    }

    public boolean getOmitOutputXMLDecl() {
        return this.m_omitxmlDecl;
    }

    public String getOutputDoctypePublic() {
        return this.m_doctypePublic;
    }

    public String getOutputDoctypeSystem() {
        return this.m_doctypeSystem;
    }

    public String getOutputEncoding() {
        return this.m_encoding;
    }

    public OutputFormat getOutputFormat() {
        OutputFormat outputFormat = new OutputFormat(this.getOutputMethod(), this.getOutputEncoding(), this.getOutputIndent());
        outputFormat.setDoctype(this.getOutputDoctypePublic(), this.getOutputDoctypeSystem());
        outputFormat.setOmitXMLDeclaration(this.getOmitOutputXMLDecl());
        outputFormat.setStandalone(this.getOutputStandalone());
        outputFormat.setMediaType(this.getOutputMediaType());
        outputFormat.setVersion(this.getOutputVersion());
        if (this.getOutputIndent()) {
            outputFormat.setIndent(outputFormat.getIndent() + 1);
        }
        return outputFormat;
    }

    public boolean getOutputIndent() {
        return this.m_indentResult;
    }

    public String getOutputMediaType() {
        return this.m_mediatype;
    }

    public String getOutputMethod() {
        return this.m_outputmethod == null ? "xml" : this.m_outputmethod;
    }

    public boolean getOutputStandalone() {
        return this.m_standalone;
    }

    public String getOutputVersion() {
        return this.m_version;
    }

    public DocumentHandler getSAXSerializer(OutputStream outputStream) throws UnsupportedEncodingException, IOException {
        return this.makeSAXSerializer(outputStream, this.getOutputFormat());
    }

    protected void init(XSLTEngineImpl xSLTEngineImpl) throws XSLProcessorException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        this.m_liaisonClassUsedToCreate = xSLTEngineImpl.getXMLProcessorLiaison().getClass().getName();
        this.m_importStack = new Stack();
        if (this.m_baseIdent == null) {
            this.m_baseIdent = "";
        }
        URL uRL = xSLTEngineImpl.getURLFromString(this.m_baseIdent, null);
        this.m_baseIdent = uRL.toExternalForm();
        this.m_importStack.push(xSLTEngineImpl.getURLFromString(this.m_baseIdent, null));
        this.m_stylesheetRoot = this;
        super.init(xSLTEngineImpl);
    }

    void initDefaultRule() throws XSLProcessorException, SAXException {
        int n = 0;
        int n2 = 0;
        MutableAttrListImpl mutableAttrListImpl = new MutableAttrListImpl();
        mutableAttrListImpl.addAttribute("match", "CDATA", "*");
        this.m_defaultRule = new ElemTemplate(null, this, "xsl:template", mutableAttrListImpl, n, n2);
        mutableAttrListImpl.clear();
        ElemApplyTemplates elemApplyTemplates = new ElemApplyTemplates(null, this, "xsl:apply-templates", mutableAttrListImpl, n, n2);
        elemApplyTemplates.m_isDefaultTemplate = true;
        this.m_defaultRule.appendChild(elemApplyTemplates);
        mutableAttrListImpl.clear();
        mutableAttrListImpl.addAttribute("match", "CDATA", "text() | @*");
        this.m_defaultTextRule = new ElemTemplate(null, this, "xsl:template", mutableAttrListImpl, n, n2);
        mutableAttrListImpl.clear();
        mutableAttrListImpl.addAttribute("select", "CDATA", ".");
        ElemValueOf elemValueOf = new ElemValueOf(null, this, "xsl:value-of", mutableAttrListImpl, n, n2);
        this.m_defaultTextRule.appendChild(elemValueOf);
        mutableAttrListImpl.clear();
        mutableAttrListImpl.addAttribute("match", "CDATA", "/");
        this.m_defaultRootRule = new ElemTemplate(null, this, "xsl:template", mutableAttrListImpl, n, n2);
        mutableAttrListImpl.clear();
        elemApplyTemplates = new ElemApplyTemplates(null, this, "xsl:apply-templates", mutableAttrListImpl, n, n2);
        elemApplyTemplates.m_isDefaultTemplate = true;
        this.m_defaultRootRule.appendChild(elemApplyTemplates);
    }

    public boolean isOutputMethodSet() {
        return this.m_outputmethod != null;
    }

    boolean isRoot() {
        return true;
    }

    public DocumentHandler makeSAXSerializer(OutputStream outputStream, OutputFormat outputFormat) throws UnsupportedEncodingException, IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (outputFormat == null) {
            outputFormat = new OutputFormat("xml", DEFAULT_ENCODING, false);
            object4 = null;
        } else if (outputFormat.getMethod().equalsIgnoreCase("html")) {
            object3 = new FormatterToHTML();
            ((FormatterToXML)object3).init(outputStream, outputFormat);
            object4 = object3;
        } else if (outputFormat.getMethod().equalsIgnoreCase("xml")) {
            object3 = new FormatterToXML();
            ((FormatterToXML)object3).init(outputStream, outputFormat);
            object4 = object3;
        } else if (outputFormat.getMethod().equalsIgnoreCase("text")) {
            object3 = outputFormat.getEncoding();
            if (object3 == null) {
                try {
                    object3 = System.getProperty("file.encoding");
                    Object object5 = object3 = object3 != null ? FormatterToXML.convertJava2MimeEncoding((String)object3) : "ASCII";
                    if (object3 == null) {
                        object3 = "ASCII";
                    }
                }
                catch (SecurityException securityException) {
                    object3 = "ASCII";
                }
            }
            this.m_encoding = object3;
            object2 = FormatterToXML.convertMime2JavaEncoding((String)object3);
            object = new OutputStreamWriter(outputStream, (String)object2);
            object4 = new FormatterToText((Writer)object);
        } else {
            object4 = outputFormat.getMethod().equalsIgnoreCase("xhtml") ? new XMLSerializer(outputStream, outputFormat) : new XMLSerializer(outputStream, outputFormat);
        }
        if (object4 == null) {
            object3 = outputFormat.getMethod();
            object2 = SerializerFactory.getSerializerFactory((String)object3);
            object = object2.makeSerializer(outputStream, outputFormat);
            object4 = object.asDocumentHandler();
        }
        return object4;
    }

    public DocumentHandler makeSAXSerializer(Writer writer, OutputFormat outputFormat) throws IOException {
        Object object;
        Object object2;
        if (outputFormat == null) {
            outputFormat = new OutputFormat("xml", DEFAULT_ENCODING, false);
            object2 = null;
        } else if (outputFormat.getMethod().equalsIgnoreCase("html")) {
            object = new FormatterToHTML();
            ((FormatterToXML)object).init(writer, outputFormat);
            object2 = object;
        } else if (outputFormat.getMethod().equalsIgnoreCase("xml")) {
            object = new FormatterToXML();
            ((FormatterToXML)object).init(writer, outputFormat);
            object2 = object;
        } else {
            object2 = outputFormat.getMethod().equalsIgnoreCase("text") ? new FormatterToText(writer) : null;
        }
        if (object2 == null) {
            object = outputFormat.getMethod();
            SerializerFactory serializerFactory = SerializerFactory.getSerializerFactory((String)object);
            Serializer serializer = serializerFactory.makeSerializer(writer, outputFormat);
            object2 = serializer.asDocumentHandler();
        }
        return object2;
    }

    public void process(XSLTInputSource xSLTInputSource, XSLTResultTarget xSLTResultTarget) throws SAXException, MalformedURLException, FileNotFoundException, IOException {
        XSLTProcessor xSLTProcessor;
        if (this.m_liaisonClassUsedToCreate != null) {
            new XSLTProcessorFactory();
            xSLTProcessor = XSLTProcessorFactory.getProcessorUsingLiaisonName(this.m_liaisonClassUsedToCreate);
        } else {
            new XSLTProcessorFactory();
            xSLTProcessor = XSLTProcessorFactory.getProcessor();
        }
        XSLTProcessor xSLTProcessor2 = xSLTProcessor;
        this.process(xSLTProcessor2, xSLTProcessor2.getSourceTreeFromInput(xSLTInputSource), xSLTResultTarget);
    }

    public void process(XSLTProcessor xSLTProcessor, XSLTInputSource xSLTInputSource, XSLTResultTarget xSLTResultTarget) throws SAXException, MalformedURLException, FileNotFoundException, IOException {
        this.process(xSLTProcessor, xSLTProcessor.getSourceTreeFromInput(xSLTInputSource), xSLTResultTarget);
    }

    public void process(XSLTProcessor xSLTProcessor, Node node, XSLTResultTarget xSLTResultTarget) throws SAXException, MalformedURLException, FileNotFoundException, IOException {
        XSLTEngineImpl xSLTEngineImpl;
        XSLTEngineImpl xSLTEngineImpl2 = xSLTEngineImpl = (XSLTEngineImpl)xSLTProcessor;
        synchronized (xSLTEngineImpl2) {
            OutputStream outputStream;
            block32: {
                xSLTEngineImpl.switchLiaisonsIfNeeded(node, xSLTResultTarget.getNode());
                xSLTEngineImpl.m_stylesheetRoot = this;
                outputStream = null;
                try {
                    Object object;
                    xSLTEngineImpl.getXMLProcessorLiaison().checkNode(node);
                    Enumeration enumeration = this.m_extensionNamespaces.keys();
                    while (enumeration.hasMoreElements()) {
                        object = enumeration.nextElement();
                        xSLTEngineImpl.getExecContext().addExtensionNamespace((String)object, (ExtensionFunctionHandler)this.m_extensionNamespaces.get(object));
                    }
                    object = this.findTemplate(xSLTEngineImpl, node, node);
                    if (object == null) {
                        object = this.m_defaultRootRule;
                    }
                    DocumentHandler documentHandler = xSLTResultTarget.getDocumentHandler();
                    OutputFormat outputFormat = this.getOutputFormat();
                    if (xSLTResultTarget.getEncoding() != null) {
                        outputFormat.setEncoding(xSLTResultTarget.getEncoding());
                    }
                    if (documentHandler != null) {
                        xSLTEngineImpl.m_flistener = documentHandler;
                    } else if (xSLTResultTarget.getByteStream() != null) {
                        if (xSLTEngineImpl.m_parserLiaison.getIndent() >= 0) {
                            outputFormat.setIndent(xSLTEngineImpl.m_parserLiaison.getIndent() + 1);
                        }
                        xSLTEngineImpl.m_flistener = this.makeSAXSerializer(xSLTResultTarget.getByteStream(), outputFormat);
                    } else if (xSLTResultTarget.getCharacterStream() != null) {
                        if (xSLTEngineImpl.m_parserLiaison.getIndent() >= 0) {
                            outputFormat.setIndent(xSLTEngineImpl.m_parserLiaison.getIndent() + 1);
                        }
                        xSLTEngineImpl.m_flistener = this.makeSAXSerializer(xSLTResultTarget.getCharacterStream(), outputFormat);
                    } else if (xSLTResultTarget.getFileName() != null) {
                        if (xSLTEngineImpl.m_parserLiaison.getIndent() >= 0) {
                            outputFormat.setIndent(xSLTEngineImpl.m_parserLiaison.getIndent() + 1);
                        }
                        outputStream = new FileOutputStream(xSLTResultTarget.getFileName());
                        xSLTEngineImpl.m_flistener = this.makeSAXSerializer(outputStream, outputFormat);
                    } else if (xSLTResultTarget.getNode() != null) {
                        if (xSLTEngineImpl.getXMLProcessorLiaison() instanceof DTMLiaison) {
                            xSLTEngineImpl.error(96);
                        }
                        switch (xSLTResultTarget.getNode().getNodeType()) {
                            case 9: {
                                xSLTEngineImpl.m_flistener = new FormatterToDOM((Document)xSLTResultTarget.getNode());
                                break;
                            }
                            case 11: {
                                xSLTEngineImpl.m_flistener = new FormatterToDOM(xSLTEngineImpl.m_parserLiaison.createDocument(), (DocumentFragment)xSLTResultTarget.getNode());
                                break;
                            }
                            case 1: {
                                xSLTEngineImpl.m_flistener = new FormatterToDOM(xSLTEngineImpl.m_parserLiaison.createDocument(), (Element)xSLTResultTarget.getNode());
                                break;
                            }
                            default: {
                                this.error(43);
                                break;
                            }
                        }
                    } else {
                        xSLTResultTarget.setNode(xSLTEngineImpl.m_parserLiaison.createDocument());
                        xSLTEngineImpl.m_flistener = new FormatterToDOM((Document)xSLTResultTarget.getNode());
                    }
                    xSLTEngineImpl.resetCurrentState(node);
                    xSLTEngineImpl.m_rootDoc = node;
                    if (xSLTEngineImpl.m_diagnosticsPrintWriter != null) {
                        xSLTEngineImpl.diag("=============================");
                        xSLTEngineImpl.diag("Transforming...");
                        xSLTEngineImpl.pushTime(node);
                    }
                    xSLTEngineImpl.getVarStack().pushContextMarker();
                    try {
                        xSLTEngineImpl.resolveTopLevelParams();
                    }
                    catch (Exception exception) {
                        throw new SAXException(XSLMessages.createMessage(44, null), exception);
                    }
                    xSLTEngineImpl.m_resultTreeHandler.startDocument();
                    ((ElemTemplate)object).execute(xSLTEngineImpl, node, node, null);
                    xSLTEngineImpl.m_resultTreeHandler.endDocument();
                    xSLTEngineImpl.m_topLevelParams = new Vector();
                    if (xSLTEngineImpl.m_diagnosticsPrintWriter == null) break block32;
                    xSLTEngineImpl.displayDuration("transform", node);
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    throw throwable;
                }
            }
            Object var9_12 = null;
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    void processOutputSpec(String string, AttributeList attributeList) throws SAXException {
        int n = attributeList.getLength();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            String string2 = attributeList.getName(n2);
            if (string2.equals("method")) {
                this.m_outputmethod = attributeList.getValue(n2);
            } else if (string2.equals("version")) {
                this.m_version = attributeList.getValue(n2);
            } else if (string2.equals("indent")) {
                this.m_indentResult = this.getYesOrNo(string2, attributeList.getValue(n2));
                bl = true;
            } else if (string2.equals("encoding")) {
                this.m_encoding = attributeList.getValue(n2);
            } else if (string2.equals("media-type")) {
                this.m_mediatype = attributeList.getValue(n2);
            } else if (string2.equals("doctype-system")) {
                this.m_doctypeSystem = attributeList.getValue(n2);
            } else if (string2.equals("doctype-public")) {
                this.m_doctypePublic = attributeList.getValue(n2);
            } else if (string2.equals("omit-xml-declaration")) {
                this.m_omitxmlDecl = this.getYesOrNo(string2, attributeList.getValue(n2));
            } else if (string2.equals("standalone")) {
                this.m_standalone = this.getYesOrNo(string2, attributeList.getValue(n2));
            } else if (string2.equals("cdata-section-elements")) {
                Object object;
                int n3;
                StringTokenizer stringTokenizer = new StringTokenizer(attributeList.getValue(n2));
                int n4 = stringTokenizer.countTokens();
                if (this.m_cdataSectionElems == null) {
                    this.m_cdataSectionElems = new QName[n4];
                    n3 = 0;
                } else {
                    object = this.m_cdataSectionElems;
                    int n5 = ((QName[])object).length;
                    this.m_cdataSectionElems = new QName[n4 + n5];
                    int n6 = 0;
                    while (n6 < n5) {
                        this.m_cdataSectionElems[n6] = object[n6];
                        ++n6;
                    }
                    n3 = n5;
                }
                while (stringTokenizer.hasMoreTokens()) {
                    QName qName;
                    object = stringTokenizer.nextToken();
                    this.m_cdataSectionElems[n3] = qName = new QName((String)object, this.m_namespaces);
                    ++n3;
                }
            } else if (!this.isAttrOK(string2, attributeList, n2)) {
                throw new SAXException(XSLMessages.createMessage(2, new Object[]{string, string2}));
            }
            ++n2;
        }
        if (this.m_outputmethod != null && this.m_outputmethod.equals("html") && !bl) {
            this.m_indentResult = true;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, SAXException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XSLProcessorException(classNotFoundException);
        }
        this.m_traceListeners = null;
    }

    public void removeTraceListener(TraceListener traceListener) {
        if (this.m_traceListeners != null) {
            this.m_traceListeners.removeElement(traceListener);
        }
    }

    public void setOutputMethod(String string) {
        this.m_outputmethod = string;
    }
}

